#ifndef DEDITBOX_H
    #define DEDITBOX_H

    #include "DBaseControlWin.h"
    #include "DString.h"

    namespace DWL {
        class DEditBox : public DBaseControlWin {
          public:
            ////////////////////////// DObjeto
            DWL_DECLARAR_DOBJETO(TEXT("DEditBox"), DEnum_Objeto_EditBox);
                                    // Constructor
                                    DEditBox(void) {};

            						//
									//! Funcin para crear un control EditBox
									//  HWND Crear(const long Estilos, HWND hWndPadre, const TCHAR *Text, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID);
		    HWND			        Crear(DBaseWnd *nPadre, const TCHAR *Text, const int cX, const int cY, const int cAncho, const int cAlto, const UINT cID, const DWORD nEstilos);
									//
									//! Funcin para asignar un EditBox ya creado en un Dialogo
									//  void Asignar(HWND hWndPadre, const int cID);
		    HWND					Asignar(DBaseWnd *nPadre, const UINT cID);

									//
									//! Funcin para asignar el caracter del password
									//  inline void CaracterPassword(const TCHAR NC);
		    inline void				CaracterPassword(const TCHAR NC) {
										SendMessage(_hWnd, EM_SETPASSWORDCHAR, NC, 0);
									};

									//
									//! Funcin para obtener el caracter del password
									//  inline const TCHAR CaracterPassword(void);
		    inline TCHAR		    CaracterPassword(void) {
										return static_cast<TCHAR>(SendMessage(_hWnd, EM_GETPASSWORDCHAR, 0, 0));
									};

									//
									//! Funcin para Asignar el Maximo de texto que podra tener el EditBox
									//  void MaximoCaracteres(const long Max);
		    inline void				MaximoCaracteres(const long Max) {
										SendMessage(_hWnd, EM_SETLIMITTEXT, Max, 0);
									};
									//
									//! Funcin para Obtener el Maximo de texto que podra tenet el EditBox
									//  inline const long MaximoTexto(void);
		    inline long			    MaximoCaracteres(void) {
										return static_cast<long>(SendMessage(_hWnd, EM_GETLIMITTEXT, 0, 0));
									};

                                    //
                                    //! Funcin para obtener el total de caracteres dentro del EditBox
                                    // inline const int TotalCaracteres(void);
            inline const int        TotalCaracteres(void) {
                                        return GetWindowTextLength(_hWnd);
                                    };

									//
									//! Funcin para obtener el numero de lineas que tiene el EditBox
									//  inline  int TotalLineas(void);
		    inline int		        TotalLineas(void) {
										return static_cast<int>(SendMessage(_hWnd, EM_GETLINECOUNT, 0, 0));
									};
									//
									//! Funcin para obtener los caracteres de una linea
									//  inline const int TotalCaracteresLinea(const int Linea);
		    inline int		        TotalCaracteresLinea(const int Linea) {
										return static_cast<int>(SendMessage(_hWnd, EM_LINELENGTH, Linea, 0));
									};

									//
									//! Funcin para reemplazar el texto del control
									//  inline void AsignarTexto(DString &nTexto);
            inline void             AsignarTexto(DString &nTexto) {
                                        SetDlgItemText(GetParent(_hWnd), static_cast<int>(GetWindowLongPtr(_hWnd, GWL_ID)), nTexto());
                                    };

									//
									//! Funcin para reemplzar el texto selecionado en el EditBox por otro
									//  inline void ReemplazarSeleccion(DString &nTexto);
		    inline void				ReemplazarSeleccion(DString &nTexto) {
										SendMessage(_hWnd, EM_REPLACESEL, FALSE, (LPARAM)(LPCSTR)nTexto());
									};

									//
									//! Funcin que retorna el texto de este control
									//  void ObtenerTexto(DString &nTexto);
		    void					ObtenerTexto(DString &nTexto);

									//
									//! Funcin para asignar el estado SoloLectura
									//  inline void SoloLectura(const bool SL);
		    inline void				SoloLectura(const bool SL) {
										SendMessage(_hWnd, EM_SETREADONLY, SL, 0);
									};

									//
									//! Funcin que retorna la fuente 
									//  inline HFONT Fuente(void);
		    inline HFONT			Fuente(void) {
										return (HFONT)SendMessage(_hWnd, WM_GETFONT, 0, 0);
									};

									//
									//! Funcin para asignar la fuente
									//  inline void Fuente(HFONT nFuente);
		    inline void				Fuente(HFONT nFuente) {
										SendMessage(_hWnd, WM_SETFONT, (WPARAM)nFuente , 0);
									};

									//
									//! Window procedure que reemplazara al WindowProcedure del EditBox
									//  LRESULT CALLBACK _GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
		    LRESULT CALLBACK        GestorMensajes(UINT uMsg, WPARAM wParam, LPARAM lParam);
                                                //! Funcin que devuelve que tipo de clase BaseWnd es esta clase
                                                /*! Esta funcin devuelve que tipo de clase BaseWnd es esta clase
                                                        \fn         virtual const DEnum_TipoBaseWnd TipoBaseWnd(void);
                                                        \returns    Devuelve un valor de DEnum_TipoBaseWnd
                                                        \remars     Esta funcin identifica que tipo de ventana o control se esta utilizando.
                                                */
            virtual const DEnum_TipoBaseWnd     TipoBaseWnd(void)   { return DEnum_TipoBaseWnd_EditBox; };

        };
    };

#endif